package com.skilldistillery.regex.solutions;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexProcessor5 {

  public static void main(String[] args) {
    RegexProcessor5 processor = new RegexProcessor5();
    processor.launch("regex_quotes.txt");
  }

  private void launch(String fileName) {
    try {
      BufferedReader br = new BufferedReader(new FileReader(fileName));
      String line;
      while ((line = br.readLine()) != null) {
//        this.printIfStartsWithHyphen(line);
//        this.printCapitalizedWords(line);
//        this.printHyphenatedWords(line);
//        String regex = "\\d+";
//        String regex = "[^\\w\\s]+";
        String regex = "[rR]eg\\w+";
        this.printTextMatchingPattern(line, regex);
      }
      br.close();
    }
    catch (FileNotFoundException e) {
      System.err.println("File not found: " + fileName);
      return;
    }
    catch (IOException e) {
      e.printStackTrace();
      return;
    }
  }
  
  private void printTextMatchingPattern(String text, String regex) {
    Pattern p = Pattern.compile(regex);
    Matcher m = p.matcher(text);
    while (m.find()) {
      System.out.println(m.group());
    }
  }

  private void printHyphenatedWords(String text) {
    Pattern p = Pattern.compile("\\b(\\w+)-(\\w+)");
    Matcher m = p.matcher(text);
    while (m.find()) {
      System.out.println(m.group());
      String word1 = m.group(1);
      String word2 = m.group(2);
      System.out.println("[" + word1 + "]" + "[" + word2 + "]");
    }
  }

  private void printCapitalizedWords(String text) {
    Pattern p = Pattern.compile("\\b[A-Z]\\w+");
    Matcher m = p.matcher(text);
    String result = "";
    while (m.find()) {
      if (result.length() != 0) {
        result += " ";
      }
      String word = m.group(); // or m.group(0)
//      System.out.println(word);
      result += word;
    }
    System.out.println(result);
  }

  private void printIfStartsWithHyphen(String text) {
    if (text.matches("^-.*")) {
      System.out.println(text);
    }
  }

}
