package com.skilldistillery.regex.solutions;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexProcessor1 {

  public static void main(String[] args) {
    RegexProcessor1 processor = new RegexProcessor1();
    processor.launch("regex_quotes.txt");
  }

  private void launch(String fileName) {
    try {
      BufferedReader br = new BufferedReader(new FileReader(fileName));
      String line;
      while ((line = br.readLine()) != null) {
        this.printIfStartsWithHyphen(line);
      }
      br.close();
    }
    catch (FileNotFoundException e) {
      System.err.println("File not found: " + fileName);
      return;
    }
    catch (IOException e) {
      e.printStackTrace();
      return;
    }
  }
  
  private void printIfStartsWithHyphen(String text) {
    if (text.matches("^-.*")) {
      System.out.println(text);
    }
  }

}
